#include "LPC15xx.h"

#define pwm_val1        (400000)                           // duty cycle PWM1
#define pwm_val2        (500000)                           // duty cycle PWM2
#define pwm_val3        (100000)                           // duty cycle PWM3
#define pwm_val4        (900000)                           // duty cycle PWM4
#define pwm_cycle       (1000000)

void SCT2_Init(void)
{
    LPC_SYSCON->SYSAHBCLKCTRL1 |= EN1_SCT2;                // enable the SCT2 clock
    LPC_SCT2->CONFIG           |= (1 << 0) | (1 << 17);    // unified timer, auto limit

    LPC_SCT2->MATCH[0].U        = pwm_cycle;               // match 0 on PWM cycle
    LPC_SCT2->MATCHREL[0].U     = pwm_cycle;
    LPC_SCT2->MATCH[1].U        = pwm_val1;                // match 1 on val1 (PWM1)
    LPC_SCT2->MATCHREL[1].U     = pwm_val1;
    LPC_SCT2->MATCH[2].U        = pwm_val2;                // match 2 on val2 (PWM2)
    LPC_SCT2->MATCHREL[2].U     = pwm_val2;
    LPC_SCT2->MATCH[3].U        = pwm_val3;                // match 3 on val3 (PWM3)
    LPC_SCT2->MATCHREL[3].U     = pwm_val3;
    LPC_SCT2->MATCH[4].U        = pwm_val4;                // match 4 on val4 (PWM4)
    LPC_SCT2->MATCHREL[4].U     = pwm_val4;

    LPC_SCT2->EVENT[0].STATE    = 0xFFFFFFFF;              // event 0 happens in all states
    LPC_SCT2->EVENT[0].CTRL     = (0 << 0) | (1 << 12);    // match 0 (pwm_cycle) only condition

    LPC_SCT2->EVENT[1].STATE    = 0xFFFFFFFF;              // event 1 happens in all states
    LPC_SCT2->EVENT[1].CTRL     = (1 << 0) | (1 << 12);    // match 1 (pwm_val1) only condition

    LPC_SCT2->EVENT[2].STATE    = 0xFFFFFFFF;              // event 2 happens in all states
    LPC_SCT2->EVENT[2].CTRL     = (2 << 0) | (1 << 12);    // match 2 (pwm_val2) only condition

    LPC_SCT2->EVENT[3].STATE    = 0xFFFFFFFF;              // event 3 happens in all states
    LPC_SCT2->EVENT[3].CTRL     = (3 << 0) | (1 << 12);    // match 3 (pwm_val3) only condition

    LPC_SCT2->EVENT[4].STATE    = 0xFFFFFFFF;              // event 4 happens in all states
    LPC_SCT2->EVENT[4].CTRL     = (4 << 0) | (1 << 12);    // match 4 (pwm_val4) only condition

    LPC_SCT2->EVENT[5].STATE    = 0xFFFFFFFF;              // event 5 happens in all states
    LPC_SCT2->EVENT[5].CTRL     = (0 << 10) | (2 << 12);   // IN_0 LOW only condition

    LPC_SCT2->OUT[0].SET        = (1 << 0);                // event 0       sets  OUT0 (PWM1)
    LPC_SCT2->OUT[0].CLR        = (1 << 1) | (1 << 5);     // event 1 and 5 clear OUT0 (PWM1)
    LPC_SCT2->OUT[1].SET        = (1 << 0);                // event 0       sets  OUT1 (PWM2)
    LPC_SCT2->OUT[1].CLR        = (1 << 2) | (1 << 5);     // event 2 and 5 clear OUT1 (PWM2)
    LPC_SCT2->OUT[2].SET        = (1 << 3) | (1 << 5);     // event 3 and 5 set   OUT2 (PWM3)
    LPC_SCT2->OUT[2].CLR        = (1 << 0);                // event 0       clear OUT2 (PWM3)
    LPC_SCT2->OUT[3].SET        = (1 << 4) | (1 << 5);     // event 4 and 5 set   OUT3 (PWM4)
    LPC_SCT2->OUT[3].CLR        = (1 << 0);                // event 0       clear OUT3 (PWM4)
    LPC_SCT2->OUTPUT            = 0x0000000C;              // default clear OUT0/1 and set OUT2/3
	LPC_SCT2->RES               = 0x0000005A;              // conflict resolution: Inactive state takes precedence
                                                           // SCT2_OUT0/1: Inactive state low
                                                           // SCT2_OUT2/3: Inactive state high

    LPC_SCT2->HALT_L            = (1 << 5);                // event 5 will halt the timer
    LPC_SCT2->LIMIT_L           = (1 << 5);                // event 5 will limit the timer
    LPC_SCT2->EVEN              = (1 << 0 ) | (1 << 5);    // event 0 and 5 will generate an irq

    NVIC_EnableIRQ(SCT2_IRQn);                             // enable SCT2 interrupt

	LPC_SCT2->CTRL_L           &= ~(1 << 2);               // start timer
}
